/*
 * This File is one of the examples from Java Object Oriented Programming
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */
package exceptions;

/**
 *
 * @author Matthew Gregory
 * @website www.matthewgregory-author.com.au
 *
 */
public class CustomException extends RuntimeException {

    private int errorCode;

    //Constructor
    CustomException(String message, int errorCode) {
        super(message);
        this.errorCode = errorCode;
    }

    //Getter
    public int getErrorCode() {
        return errorCode;
    }
    
    //Override toString
    @Override
    public String toString(){
        return super.toString()+" - "+errorCode;
    }
}
